/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerFluidAmount;
import com.raoulvdberge.refinedstorage.gui.GuiAmountSpecifying;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.network.MessageSlotFilterFluidSetAmount;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFluidAmount
extends GuiAmountSpecifying {
    private final int containerSlot;
    private final FluidStack stack;
    private final int maxAmount;

    public GuiFluidAmount(GuiBase parent, EntityPlayer player, int containerSlot, FluidStack stack, int maxAmount) {
        super(parent, new ContainerFluidAmount(player, stack), 172, 99);
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.amount;
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected String getOkButtonText() {
        return GuiFluidAmount.t("misc.refinedstorage:set", new Object[0]);
    }

    @Override
    protected String getTitle() {
        return GuiFluidAmount.t("gui.refinedstorage:fluid_amount", new Object[0]);
    }

    @Override
    protected String getTexture() {
        return "gui/crafting_settings.png";
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{100, 500, 1000, -100, -500, -1000};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        Integer amount = Ints.tryParse((String)this.amountField.func_146179_b());
        if (amount != null) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageSlotFilterFluidSetAmount(this.containerSlot, amount));
            this.close();
        }
    }
}

